@building-option +create-set-co
@create dow named dns header waif:dns header waif,dhw,header
@prop _."id" 44672 r
@prop _."rcodes" {} r
;_.("rcodes") = {"Query format error", "Server failure", "Non existant host/domain", "Not Implemented", "Query Refused"}
@prop _."query" #-1 r
@prop _."resource" #-1 r
@prop _.":id" 0 r
@prop _.":qr" 0 rc
@prop _.":opcode" 0 rc
@prop _.":aa" 0 rc
@prop _.":tc" 0 rc
@prop _.":rd" 1 rc
@prop _.":ra" 0 rc
@prop _.":ad" 0 rc
@prop _.":cd" 0 rc
@prop _.":rcode" 0 rc
@prop _.":queries" {} r
@prop _.":answers" {} r
@prop _.":nss" {} r
@prop _.":adrecs" {} r
;_.("aliases") = {"dns header waif", "dhw", "header"}

@verb _:"decode" this none this
@program _:decode
{msg} = args;
if (typeof(msg) == STR)
  msg = decode_binary(msg, 1);
endif
w = new_waif();
w.id = (msg[1] * 256) + msg[2];
bits = this:bits(msg[3]);
w.qr = bits[1];
w.opcode = this:encode_byte(0, 0, 0, 0, @bits[2..5]);
w.aa = bits[6];
w.tc = bits[7];
w.rd = bits[8];
bits = this:bits(msg[4]);
w.ra = bits[1];
bits[1] = 0;
w.rcode = this:encode_byte(@bits);
offs = 13;
typeo = {this.query, this.resource, this.resource, this.resource};
types = {"queries", "answers", "nss", "adrecs"};
for type in [1..4]
  cnt = (msg[3 + (type * 2)] * 256) + msg[4 + (type * 2)];
  res = {};
  for i in [1..cnt]
    {rr, offs} = typeo[type]:decode(msg, offs);
    res = {@res, rr};
  endfor
  if (res)
    w.(types[type]) = res;
  endif
endfor
return w;
.

@verb _:"next_id" this none this
@program _:next_id
id = this.id = this.id + 1;
if (id > 65535)
  id = this.id = 1;
endif
return id;
.

@verb _:":initialize" this none this
@program _::initialize
if ((this.id == 0) && ((caller == this.class) || (caller == this)))
  this.id = this.class:next_id();
endif
.

@verb _:":encode" this none this
@program _::encode
res = this:encode_header();
for q in (this.queries)
  res = {@res, q:encode()};
endfor
return encode_binary(res);
.

@verb _:":encode_header" this none this
@program _::encode_header
x = this.class;
res = {};
res = {@res, @x:encode_short(this.id)};
res = {@res, x:encode_byte(this.qr, 0, 0, 0, this.opcode, this.aa, this.tc, this.rd, this.ra), this.rcode};
res = {@res, @x:encode_short(length(this.queries))};
res = {@res, @x:encode_short(length(this.answers))};
res = {@res, @x:encode_short(length(this.nss))};
res = {@res, @x:encode_short(length(this.adrecs))};
return res;
.

@verb _:":add_query" this none this
@program _::add_query
if ((caller == this) || $perm_utils:controls(caller_perms(), this))
  {q} = args;
  if ($object_utils:isa(q.class, this.class.query))
    this.queries = {@this.queries, q};
  else
    raise(E_TYPE);
  endif
else
  raise(E_PERM);
endif
.

@verb _:":rcode_str" this none this
@program _::rcode_str
if ((this.rcode > 0) && (this.rcode <= length(this.class.rcodes)))
  return this.class.rcodes[this.rcode];
else
  return "";
endif
.

@verb _:":print" this none this
@program _::print
res = {";; QUESTIONS:"};
for q in (this.queries)
  for line in (q:print())
    res = {@res, ";;     " + line};
  endfor
endfor
headers = {";; ANSWERS:", ";; AUTHORITY RECORDS:", ";; ADDITIONAL RECORDS:"};
props = {"answers", "nss", "adrecs"};
for i in [1..3]
  res = {@res, "", headers[i]};
  for q in (this.(props[i]))
    res = {@res, @q:print()};
  endfor
endfor
return res;
.

"***finished***
