@building-option +create-set-co
@create dow named dns query waif:dns query waif,dqw
@prop _.":qname" "" r
@prop _.":qtype" 12 r
@prop _.":qclass" 1 r
;_.("type") = 10
;_.("aliases") = {"dns query waif", "dqw"}

@verb _:"decode" this none this
@program _:decode
{msg, offs} = args;
w = new_waif();
{name, offs} = w:unpack_name(msg, offs);
w.qname = name;
sz = offs - 1;
w.qtype = (msg[sz + 1] * 256) + msg[sz + 2];
w.qclass = (msg[sz + 3] * 256) + msg[sz + 4];
return {w, offs + 4};
.

@verb _:":initialize" this none this
@program _::initialize
if ((caller == this) || (caller == this.class))
  pass(@args);
  {qname, qtype, qclass} = args;
  if (typeof(qtype) == STR)
    x = qtype in $local.resolver.types;
    if (!x)
      return raise(E_INVARG, "Invalid query type string " + qtype);
    endif
    qtype = x;
  endif
  if (typeof(qclass) == STR)
    x = qclass in $local.resolver.classes;
    if (!x)
      return raise(E_INVARG, "Invalid query class string " + qclass);
    endif
    qclass = x;
  endif
  if (qtype != this.qtype)
    this.qtype = qtype;
  endif
  if (qclass != this.qclass)
    this.qclass = qclass;
  endif
  this.qname = qname;
endif
.

@verb _:":encode" this none this
@program _::encode
hdr = $local.resolver.header;
return {@this:pack_name(this.qname), @hdr:encode_short(this.qtype), @hdr:encode_short(this.qclass)};
.

@verb _:":print" this none this
@program _::print
return {tostr(this.qname, ", type = ", `$local.resolver.types[this.qtype][3..$] ! ANY', ", class = ", `$local.resolver.classes[this.qclass][3..$] ! ANY')};
.

"***finished***
