@building-option +create-set-co
@create $utils named resolver utils:resolver utils,resolver
@prop _."header" #-1 r
@prop _."server" "127.0.0.1" r
@prop _."receive_error" "receive error" r
@prop _."port" 53 r
@prop _."con" #-1 r
@prop _."types" {} r
;_.("types") = {"T_A", "T_NS", "T_MD", "T_MF", "T_CNAME", "T_SOA", "T_MB", "T_MG", "T_MR", "T_NULL", "T_WKS", "T_PTR", "T_HINFO", "T_MINFO", "T_MX", "T_TXT", "T_RP", "T_AFSDB", "T_X25", "T_ISDN", "T_RT", "T_NSAP", "T_NSAP_PTR", "T_SIG", "T_KEY", "T_PX", "T_GPOS", "T_AAAA", "T_LOC", "T_NXT", "T_EID", "T_NIMLOC", "T_SRV", "T_ATMA", "T_NAPTR"}
@prop _."help_text" {} rc
;_.("help_text") = {":gethostbyname(\"hostname\") => \"w.x.y.z\"", "", ":gethostbyaddr(\"w.x.y.z\") => \"hostname\"", "", "dig <hostname> with $local.resolver"}
@prop _."mutex" "" ""
@prop _."classes" {} r
;_.("classes") = {"C_IN", "C_CS", "C_CH", "C_HS"}
;_.("aliases") = {"resolver utils", "resolver"}

@verb _:"dig dig-mx dig-hinfo dig-cname dig-loc dig-ns dig-soa dig-srv dig-txt dig-ch-txt" any with this rxd
@program _:dig
host = dobjstr;
hdr = this.header:new();
try
  {dig, ?class = "IN", type} = $string_utils:explode(verb, "-");
except (E_ARGS)
  class = "IN";
  type = "A";
endtry
class = "C_" + class;
type = "T_" + type;
hdr:add_query(hdr.class.query:new(host, type, class));
res = this:send(hdr);
player:notify_lines(res:print());
player:notify("Done.");
.

@verb _:"gethostbyname" this none this
@program _:gethostbyname
{name} = args;
hdr = this.header:new();
query = hdr.class.query:new(name, "T_A", "C_IN");
hdr:add_query(query);
ret = this:send(hdr);
if (ret.rcode)
  raise(ret:rcode_str());
endif
"find a nice T_A";
T_A = "T_A" in this.types;
res = {};
for ans in (ret.answers)
  if (ans.type == T_A)
    return ans.rdata;
  endif
endfor
return res;
.

@verb _:"gethostbyaddr" this none this
@program _:gethostbyaddr
{name} = args;
name = $string_utils:from_list($list_utils:reverse($string_utils:explode(name, ".")), ".") + ".in-addr.arpa";
hdr = this.header:new();
query = hdr.class.query:new(name, "T_PTR", "C_IN");
hdr:add_query(query);
ret = this:send(hdr);
if (ret.rcode)
  raise(ret:rcode_str());
endif
for ans in (ret.answers)
  if (ans.type == query.qtype)
    return ans.rdata;
  endif
endfor
raise("No PTR records returned!");
.

@verb _:"send" this none this
@program _:send
{hdr, ?raw = 0} = args;
msg = hdr:encode();
msglen = length(decode_binary(msg, 1));
msg = encode_binary(this.header:encode_short(msglen)) + msg;
try
  this.mutex:p();
  for attempt in [1..3]
    try
      con = this:nameserver_con();
      notify(con, msg);
      res = read(con);
      break attempt;
    except (E_INVARG)
      if (attempt == 3)
        return raise(this.receive_error);
      endif
    endtry
  endfor
finally
  this.mutex:v();
endtry
"first two bytes are length";
res = decode_binary(res, 1);
len = (res[1] * 256) + res[2];
if (len != (length(res) - 2))
  raise(this.receive_error);
endif
res = res[3..$];
if (raw)
  return res;
else
  return this.header:decode(res);
endif
.

@verb _:"nameserver_con" this none this
@program _:nameserver_con
if (caller == this)
  con = this.con;
  if (typeof(`idle_seconds(con) ! E_INVARG, E_TYPE') == ERR)
    con = this.con = open_network_connection(this.server, this.port);
    set_connection_option(con, "hold-input", 1);
    set_connection_option(con, "binary", 1);
  endif
  return con;
else
  raise(E_PERM);
endif
.

@verb _:"getmxbyname" this none this
@program _:getmxbyname
{name, ?class = "T_A"} = args;
T_MX = "T_MX" in this.types;
hdr = this.header:new();
query = hdr.class.query:new(name, T_MX, "C_IN");
hdr:add_query(query);
ret = this:send(hdr);
if (ret.rcode)
  raise(ret:rcode_str());
endif
"find a response";
res = {};
for ans in (ret.answers)
  if (ans.type == T_MX)
    res = {@res, ans.rdata};
  endif
endfor
return res;
.

"***finished***
