@building-option +create-set-co
@create dow named dns resource record waif:dns resource record waif,drrw,rrw,rr,resource record waif,res
@prop _.":name" "" r
@prop _.":type" 0 r
@prop _.":_class" 0 r
@prop _.":ttl" 0 r
@prop _.":rdlength" 0 r
@prop _.":rdata" "" r
;_.("aliases") = {"dns resource record waif", "drrw", "rrw", "rr", "resource record waif", "res"}

@verb _:"decode" this none this
@program _:decode
"RFC 1035";
{msg, offs} = args;
w = new_waif();
{name, offs} = w:unpack_name(msg, offs);
w.name = name;
base = offs - 1;
w.type = (msg[base + 1] * 256) + msg[base + 2];
w._class = (msg[base + 3] * 256) + msg[base + 4];
w.ttl = (((msg[base + 5] * 16777216) + (msg[base + 6] * 65536)) + (msg[base + 7] * 256)) + msg[base + 8];
rdlength = (msg[base + 9] * 256) + msg[base + 10];
base = offs + 10;
if (w.type == 6)
  "T_SOA";
  {mname, base} = w:unpack_name(msg, base);
  {rname, base} = w:unpack_name(msg, base);
  {serial, base} = w:unpack_int32(msg, base);
  {refresh, base} = w:unpack_int32(msg, base);
  {retry, base} = w:unpack_int32(msg, base);
  {expire, base} = w:unpack_int32(msg, base);
  {minimum, base} = w:unpack_int32(msg, base);
  w.rdata = {mname, rname, serial, refresh, retry, expire, minimum};
elseif (w.type == 15)
  "T_MX";
  pref = (msg[base] * 256) + msg[base + 1];
  w.rdata = {pref, w:unpack_name(msg, base + 2)[1]};
elseif (w.type in {2, 5, 12, 15})
  "T_NS, T_CNAME, T_PTR";
  w.rdata = w:unpack_name(msg, base)[1];
elseif (w.type in {10, 13, 16})
  "T_NULL, T_HINFO, T_TXT";
  end = (base + rdlength) - 1;
  w.rdata = {};
  while (base < end)
    n = msg[base];
    w.rdata = {@w.rdata, encode_binary(msg[base + 1..base + n])};
    base = (base + n) + 1;
  endwhile
elseif (w.type == 1)
  "T_A";
  w.rdata = $string_utils:from_list(msg[base..base + 3], ".");
elseif (w.type == 33)
  "T_SRV";
  weight = (msg[base] * 256) + msg[base + 1];
  base = base + 2;
  port = (msg[base] * 256) + msg[base + 1];
  base = base + 2;
  target = (msg[base] * 256) + msg[base + 1];
  base = base + 2;
  w.rdata = {weight, port, target, w:unpack_name(msg, base)[1]};
else
  "#269:debug({msg, base, rdlength});";
  w.rdata = msg[base..(base + rdlength) - 1];
endif
return {w, (offs + 10) + rdlength};
.

@verb _:":print" this none this
@program _::print
rdata = this.rdata;
if (this.type == 15)
  "T_MX";
  rdata = tostr("preference = ", rdata[1], ", mail exchanger = ", rdata[2]);
elseif (this.type == 33)
  "T_SRV";
  rdata = tostr("priority = ", rdata[1], ", weight = ", rdata[2], ", port = ", rdata[3], ", target = ", rdata[4]);
elseif (typeof(rdata) == LIST)
  rdata = toliteral(rdata);
endif
return {tostr(this.name, "  ", this.ttl, "   ", $local.resolver.types[this.type][3..$], "  ", rdata)};
.

"***finished***
