@building-option +create-set-co
@create $waif named dns object waif:dns object waif,dow
;_.("aliases") = {"dns object waif", "dow"}

@verb _:"bits" this none this
@program _:bits
x = args[1];
l = {};
for i in [1..8]
  l = {x % 2, @l};
  x = x / 2;
endfor
return l;
.

@verb _:"encode_short" this none this
@program _:encode_short
x = args[1] / 256;
return {x, args[1] - (x * 256)};
.

@verb _:"encode_byte" this none this
@program _:encode_byte
res = 0;
fac = 128;
for a in (args)
  res = res + (fac * a);
  fac = fac / 2;
endfor
return res;
.

@verb _:":pack_name" this none this
@program _::pack_name
{name} = args;
segments = $string_utils:explode(name, ".");
if (segments[$] != "")
  segments = {@segments, ""};
endif
res = {};
for seg in (segments)
  res = {@res, length(seg), seg};
endfor
return res;
.

@verb _:":unpack_name" this none this
@program _::unpack_name
{msg, i} = args;
res = {};
r = -1;
while (msg[i])
  if (msg[i] > 63)
    if (r < 0)
      r = i + 2;
    endif
    i = msg[i + 1] + 1;
  endif
  res = {@res, encode_binary(msg[i + 1..i + msg[i]])};
  i = (i + msg[i]) + 1;
endwhile
return {$string_utils:from_list(res, "."), (r > 0) ? r | (i + 1)};
.

@verb _:":unpack_int32" this none this
@program _::unpack_int32
{msg, offs} = args;
val = (((msg[offs] * 16777216) + (msg[offs + 1] * 65536)) + (msg[offs + 2] * 256)) + msg[offs + 3];
offs = offs + 4;
return {val, offs};
.

"***finished***
