@building-option +create-set-co
@create $waif named XML tree node:XML tree node
@prop _.":name" "" r
@prop _.":text" "" r
@prop _.":children" {} r
@prop _.":attributes" {} r
;_.("aliases") = {"XML tree node"}

@verb _:":get" this none this
@program _::get
{name, ?default = E_PROPNF} = args;
if (a = $list_utils:assoc(name, this.attributes))
  return a[2];
else
  return default;
endif
.

@verb _:":initialize" this none this
@program _::initialize
{tag, attrs, text, children} = args[1];
if ((caller == this) || (caller == this.class))
  pass(@args);
  this.name = tag;
  this.attributes = attrs;
  this.text = text;
  this.children = $list_utils:map_arg($local.xml.node, "new", children);
else
  raise(E_PERM);
endif
.

@verb _:":children" this none this
@program _::children
{?name = -1} = args;
if (name == -1)
  "no filter";
  return this.children;
else
  children = {};
  for child in (this.children)
    if (child.name == name)
      children = {@children, child};
    endif
  endfor
  return children;
endif
.

@verb _:":get_child" this none this
@program _::get_child
{name} = args;
for child in (this.children)
  if (child.name == name)
    return child;
  endif
endfor
return $nothing;
.

@verb _:":select" this none this
@program _::select
"this is NOT XPath, it's a poor, poor substitude for XPath";
"Selects matching nodes below this one";
"elt matches an element name";
"@elt matches an attribute name";
{path} = args;
if (typeof(path) == LIST)
  segments = path;
else
  segments = $string_utils:explode(path, "/");
endif
if (length(segments) == 1)
  name = segments[1];
  if (name[1] == "@")
    val = this:get(name[2..$]);
    if (val != E_PROPNF)
      return {val};
    else
      return {};
    endif
  else
    result = {};
    for elt in (this.children)
      if (elt.name == name)
        result = {@result, elt};
      endif
    endfor
    return result;
  endif
else
  node = this;
  result = {};
  name = segments[1];
  rest = segments[2..$];
  if (name[1] == "@")
    raise(E_INVARG, "Can't traverse attribute names in the middle of a path");
  endif
  for elt in (this.children)
    if (elt.name == name)
      result = {@result, @elt:select(rest)};
    endif
  endfor
  return result;
endif
.

@verb _:":dump_tree" this none this
@program _::dump_tree
return {this.name, this.attributes, this.text, $list_utils:map_verb(this.children, "dump_tree")};
.

@verb _:":unparse" this none this
@program _::unparse
return $local.xml:xml_unparse(@this:dump_tree());
.

@verb _:":select_one_text" this none this
@program _::select_one_text
{path, ?notfound = ""} = args;
nodes = this:select(path);
if (!nodes)
  return notfound;
else
  return nodes[1].text;
endif
.

"***finished***
